/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.KeyCollectionImpl;
import org.magicwerk.brownies.collections.KeyListImpl;
import org.magicwerk.brownies.collections.function.IConsumer;
import org.magicwerk.brownies.collections.function.IPredicate;

public class KeyList<E>
extends KeyListImpl<E> {
    protected KeyList() {
    }

    protected Builder<E> getBuilder() {
        return new Builder(this);
    }

    @Override
    public KeyList<E> copy() {
        return (KeyList)super.copy();
    }

    @Override
    public KeyList<E> crop() {
        return (KeyList)super.crop();
    }

    @Override
    public IList<E> getAll(E elem) {
        return super.getAll(elem);
    }

    @Override
    public int getCount(E elem) {
        return super.getCount(elem);
    }

    @Override
    public IList<E> removeAll(E elem) {
        return super.removeAll(elem);
    }

    @Override
    public Set<E> getDistinct() {
        return super.getDistinct();
    }

    @Override
    public E put(E elem) {
        return super.put(elem);
    }

    @Override
    public KeyList<E> unmodifiableList() {
        return new ImmutableKeyList(this);
    }

    protected KeyList(boolean copy2, KeyList<E> that) {
        if (copy2) {
            this.doAssign(that);
        }
    }

    protected static class ImmutableKeyList<E>
    extends KeyList<E> {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableKeyList(KeyList<E> that) {
            super(true, that);
        }

        @Override
        protected void doEnsureCapacity(int capacity) {
            this.error();
        }

        @Override
        protected boolean doAdd(int index, E elem) {
            this.error();
            return false;
        }

        @Override
        protected E doSet(int index, E elem) {
            this.error();
            return null;
        }

        @Override
        protected E doReSet(int index, E elem) {
            this.error();
            return null;
        }

        @Override
        protected E doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    public static class Builder<E>
    extends KeyCollectionImpl.BuilderImpl<E> {
        public Builder() {
            this(null);
        }

        Builder(KeyList<E> keyList) {
            this.keyList = keyList;
            this.initKeyMapBuilder(0);
        }

        @Override
        public Builder<E> withNull(boolean allowNull) {
            return (Builder)super.withNull(allowNull);
        }

        @Override
        public Builder<E> withConstraint(IPredicate<E> constraint) {
            return (Builder)super.withConstraint(constraint);
        }

        @Override
        public Builder<E> withBeforeInsertTrigger(IConsumer<E> trigger) {
            return (Builder)super.withBeforeInsertTrigger(trigger);
        }

        @Override
        public Builder<E> withAfterInsertTrigger(IConsumer<E> trigger) {
            return (Builder)super.withAfterInsertTrigger(trigger);
        }

        @Override
        public Builder<E> withBeforeDeleteTrigger(IConsumer<E> trigger) {
            return (Builder)super.withBeforeDeleteTrigger(trigger);
        }

        @Override
        public Builder<E> withAfterDeleteTrigger(IConsumer<E> trigger) {
            return (Builder)super.withAfterDeleteTrigger(trigger);
        }

        @Override
        public Builder<E> withCapacity(int capacity) {
            return (Builder)super.withCapacity(capacity);
        }

        @Override
        public Builder<E> withContent(Collection<? extends E> elements) {
            return (Builder)super.withContent(elements);
        }

        @Override
        public Builder<E> withContent(E ... elements) {
            return (Builder)super.withContent(elements);
        }

        @Override
        public Builder<E> withMaxSize(int maxSize) {
            return (Builder)super.withMaxSize(maxSize);
        }

        @Override
        public Builder<E> withWindowSize(int maxSize) {
            return (Builder)super.withWindowSize(maxSize);
        }

        @Override
        public Builder<E> withListBig(boolean bigList) {
            return (Builder)super.withListBig(bigList);
        }

        @Override
        public Builder<E> withListType(Class<?> type) {
            return (Builder)super.withListType(type);
        }

        @Override
        public Builder<E> withElemSet() {
            return (Builder)super.withElemSet();
        }

        @Override
        public Builder<E> withOrderByElem(boolean orderBy) {
            return (Builder)super.withOrderByElem(orderBy);
        }

        @Override
        public Builder<E> withOrderByElem(Class<?> type) {
            return (Builder)super.withOrderByElem(type);
        }

        @Override
        public Builder<E> withElemNull(boolean allowNull) {
            return (Builder)super.withElemNull(allowNull);
        }

        @Override
        public Builder<E> withElemDuplicates(boolean allowDuplicates) {
            return (Builder)super.withElemDuplicates(allowDuplicates);
        }

        @Override
        public Builder<E> withElemDuplicates(boolean allowDuplicates, boolean allowDuplicatesNull) {
            return (Builder)super.withElemDuplicates(allowDuplicates, allowDuplicatesNull);
        }

        @Override
        public Builder<E> withElemSort(boolean sort) {
            return (Builder)super.withElemSort(sort);
        }

        @Override
        public Builder<E> withElemSort(Comparator<? super E> comparator) {
            return (Builder)super.withElemSort(comparator);
        }

        @Override
        public Builder<E> withElemSort(Comparator<? super E> comparator, boolean sortNullsFirst) {
            return (Builder)super.withElemSort(comparator, sortNullsFirst);
        }

        @Override
        public Builder<E> withPrimaryElem() {
            return (Builder)super.withPrimaryElem();
        }

        @Override
        public Builder<E> withUniqueElem() {
            return (Builder)super.withUniqueElem();
        }

        public KeyList<E> build() {
            if (this.keyColl == null) {
                this.keyColl = new KeyCollectionImpl();
            }
            this.build(this.keyColl, true);
            KeyList list2 = new KeyList();
            this.init(this.keyColl, list2);
            return list2;
        }
    }
}

